/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.menu;

import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.UIRegistration;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MachineRoomMenu
extends AbstractContainerMenu {
    private final ChunkPos room;
    private String roomName;
    private final LevelBlockPosition machine;
    private StructureTemplate roomBlocks;

    public MachineRoomMenu(int win, ChunkPos room, LevelBlockPosition machine, String roomName) {
        super((MenuType)UIRegistration.MACHINE_MENU.get(), win);
        this.room = room;
        this.roomName = roomName;
        this.roomBlocks = new StructureTemplate();
        this.machine = machine;
    }

    public ChunkPos getRoom() {
        return this.room;
    }

    public LevelBlockPosition getMachine() {
        return this.machine;
    }

    public static MenuProvider makeProvider(final MinecraftServer server, final ChunkPos roomId, final LevelBlockPosition machinePos) {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("compactmachines.ui.room");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int winId, Inventory inv, Player player2) {
                try {
                    Optional<String> title = Rooms.getRoomName(server, roomId);
                    MachineRoomMenu menu = new MachineRoomMenu(winId, roomId, machinePos, title.orElse("Room Preview"));
                    menu.roomBlocks = Rooms.getInternalBlocks(server, roomId);
                    return menu;
                }
                catch (MissingDimensionException | NonexistentRoomException e) {
                    return null;
                }
            }
        };
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slotInd) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    @Nullable
    public StructureTemplate getBlocks() {
        return this.roomBlocks;
    }

    public void setBlocks(StructureTemplate blocks) {
        this.roomBlocks = blocks;
    }

    public String getRoomName() {
        return this.roomName;
    }
}

